/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.AbstractStoreSchedule;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

abstract class AbstractStoreView
extends AbstractStoreSchedule {
    private List<AbstractStoreSchedule> cacheUpdateSources = Lists.newArrayListWithCapacity(2);
    private boolean alwaysUpdate = false;

    protected AbstractStoreView(Set<? extends Material> materials, Collection<StoreSchedule> sources) {
        super(materials);
        this.activities = Maps.newHashMap();
        for (Material material : materials) {
            this.activities.put(material, Lists.newArrayList());
        }
        for (StoreSchedule storeSchedule : sources) {
            this.registerCacheUpdateSource(storeSchedule);
        }
    }

    protected abstract void createCache(Material var1);

    private void registerCacheUpdateSource(StoreSchedule ss) {
        if (!this.alwaysUpdate && ss instanceof AbstractStoreSchedule) {
            this.cacheUpdateSources.add((AbstractStoreSchedule)ss);
        } else {
            this.alwaysUpdate = true;
            this.cacheUpdateSources = null;
        }
    }

    protected synchronized void updateCache(Material m3) {
        if (this.alwaysUpdate) {
            this.createCache(m3);
        } else {
            int v = 0;
            for (AbstractStoreSchedule ss : this.cacheUpdateSources) {
                if (ss instanceof AbstractStoreView) {
                    ((AbstractStoreView)ss).updateCache(m3);
                }
                v += ss.getVersion(m3);
            }
            if (v != this.getVersion(m3)) {
                this.createCache(m3);
                this.setVersion(m3, v);
            }
        }
    }

    protected void updateEveryCache() {
        for (Material m3 : this.activities.keySet()) {
            this.updateCache(m3);
        }
    }

    @Override
    public void addActivities(Collection<? extends StoreActivity> activities) {
        throw new UnsupportedOperationException("Cannot modify store view.");
    }

    @Override
    public void addActivity(StoreActivity activity) {
        throw new UnsupportedOperationException("Cannot modify store view.");
    }

    @Override
    public boolean removeActivity(StoreActivity activity) {
        throw new UnsupportedOperationException("Cannot modify store view.");
    }

    @Override
    public void removeActivities(Collection<? extends StoreActivity> activities) {
        throw new UnsupportedOperationException("Cannot modify store view.");
    }

    @Override
    public void removeAllActivities() {
        throw new UnsupportedOperationException("Cannot modify store view.");
    }

    @Override
    protected List<StoreActivity> getMatActList(Material material) {
        this.updateCache(material);
        return super.getMatActList(material);
    }

    @Override
    protected List<StoreActivity> getMatActList(StoreActivity activity) {
        if (activity != null) {
            this.updateCache(activity.getMaterial());
        }
        return super.getMatActList(activity);
    }

    @Override
    protected Collection<List<StoreActivity>> getMatActLists() {
        this.updateEveryCache();
        return super.getMatActLists();
    }

    @Override
    public Iterator<StoreActivity> activitiesIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<StoreActivity> sortedActivitiesIterator() {
        this.updateEveryCache();
        return super.sortedActivitiesIterator();
    }
}

